/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.materials;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_2561;
import net.minecraft.class_3300;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import slimeknights.mantle.client.ResourceColorManager;
import slimeknights.mantle.data.fabric.IdentifiableISafeManagerReloadListener;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.utils.Util;

public class MaterialTooltipCache {
    private static final Map<MaterialVariantId, String> KEY_CACHE = new HashMap<MaterialVariantId, String>();
    private static final Map<MaterialVariantId, class_5251> COLOR_CACHE = new HashMap<MaterialVariantId, class_5251>();
    private static final Map<MaterialVariantId, class_2561> DISPLAY_NAME_CACHE = new HashMap<MaterialVariantId, class_2561>();
    private static final Map<MaterialVariantId, class_2561> COLORED_DISPLAY_NAME_CACHE = new HashMap<MaterialVariantId, class_2561>();
    private static final IdentifiableISafeManagerReloadListener RELOAD_LISTENER = new IdentifiableISafeManagerReloadListener(TConstruct.getResource("tool_materials")){

        @Override
        public void onReloadSafe(class_3300 resourceManager) {
            COLOR_CACHE.clear();
            DISPLAY_NAME_CACHE.clear();
            COLORED_DISPLAY_NAME_CACHE.clear();
        }
    };
    private static final Function<MaterialVariantId, String> KEY_GETTER = id -> Util.makeTranslationKey("material", id.getLocation('.'));
    private static final Function<MaterialVariantId, class_5250> DISPLAY_NAME_GETTER = id -> {
        String variantKey;
        if (id.hasVariant() && Util.canTranslate(variantKey = MaterialTooltipCache.getKey(id))) {
            return class_2561.method_43471((String)variantKey);
        }
        return class_2561.method_43471((String)MaterialTooltipCache.getKey(id.getId()));
    };
    public static final Function<MaterialVariantId, class_5251> COLOR_GETTER = id -> {
        String variantKey;
        class_5251 color;
        if (id.hasVariant() && (color = ResourceColorManager.getOrNull(variantKey = MaterialTooltipCache.getKey(id))) != null) {
            return color;
        }
        return ResourceColorManager.getTextColor(MaterialTooltipCache.getKey(id.getId()));
    };
    private static final Function<MaterialVariantId, class_2561> COLORED_DISPLAY_NAME_GETTER = id -> {
        class_5251 color = MaterialTooltipCache.getColor(id);
        if ((color.method_27716() & 0xFFFFFF) != 0xFFFFFF) {
            return DISPLAY_NAME_GETTER.apply((MaterialVariantId)id).method_27694(style -> style.method_27703(color));
        }
        return MaterialTooltipCache.getDisplayName(id);
    };

    private MaterialTooltipCache() {
    }

    public static void init(ResourceManagerHelper manager) {
        manager.registerReloadListener((IdentifiableResourceReloadListener)RELOAD_LISTENER);
    }

    public static String getKey(MaterialVariantId variantId) {
        return KEY_CACHE.computeIfAbsent(variantId, KEY_GETTER);
    }

    public static class_2561 getDisplayName(MaterialVariantId variantId) {
        return (class_2561)DISPLAY_NAME_CACHE.computeIfAbsent(variantId, DISPLAY_NAME_GETTER);
    }

    public static class_5251 getColor(MaterialVariantId id) {
        return COLOR_CACHE.computeIfAbsent(id, COLOR_GETTER);
    }

    public static class_2561 getColoredDisplayName(MaterialVariantId variantId) {
        return COLORED_DISPLAY_NAME_CACHE.computeIfAbsent(variantId, COLORED_DISPLAY_NAME_GETTER);
    }
}

